<?php

namespace TCG\Voyager\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Pages extends Model 
{

    protected $table = 'pages';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'excerpt', 'body', 'image', 'slug', 'meta_description', 'meta_keywords', 'status');
    protected $visible = array('title', 'excerpt', 'body', 'image', 'slug', 'meta_description', 'meta_keywords', 'status');

    public function author()
    {
        return $this->hasOne('TCG\Voyager\Models\User');
    }

}